<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

$productCount = \App\Models\Product::count();
echo "Total products in database: " . $productCount . PHP_EOL;

if ($productCount > 0) {
    echo "\nFirst few products:" . PHP_EOL;
    $products = \App\Models\Product::limit(3)->get();
    foreach ($products as $product) {
        echo "- ID: {$product->id}, Name: {$product->name}, Stock: {$product->stock}" . PHP_EOL;
    }
} else {
    echo "No products found. You may need to add some products first." . PHP_EOL;
}